{
 -------------------------------------------------------------------------
 Copyright (C) 1998-2003 Hger+Busch                   / >>>>>>>>> /-----
 Ingenieurbuero fuer Kommunikationslsungen           / <<<<<<<<< /
 ----------------------------------------------------/ >>>>>>>>> /
 All rights reserved.
                                                    http://www.commso.com

 Project     : hbTapi Components
 Modul       : AddressTranslation

 Description :

 This sample shows how to translate an address (phone number) to the
 dialable format and how to show the location/translate dialog.

 History     : [-] Fixed [+] Added [*] Improved

 01/01/03   Creation
}
unit uMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  hbTAPI, Tapi, StdCtrls;

type
  TForm1 = class(TForm)
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    Button1: TButton;
    Button2: TButton;
    TapiLine1: TTapiLine;
    ComboBox3: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  ComboBox1.Items.Assign(TapiLine1.DeviceList);
  if ComboBox1.Items.Count > 0 then
    ComboBox1.ItemIndex := 0;
  ComboBox1Change(ComboBox1);
  ComboBox3.ItemIndex := 0;
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
  TapiLine1.DeviceID := ComboBox1.ItemIndex;
  ComboBox2.Enabled := TapiLine1.Available;
  ComboBox3.Enabled := TapiLine1.Available;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  TapiLine1.TranslateDialog(Combobox2.Text, Handle);
end;

procedure TForm1.Button2Click(Sender: TObject);
var o: DWORD;
begin
 case ComboBox3.ItemIndex of
   1 : o := LINETRANSLATEOPTION_CARDOVERRIDE;
   2 : o := LINETRANSLATEOPTION_CANCELCALLWAITING;
   3 : o := LINETRANSLATEOPTION_FORCELOCAL;
   4 : o := LINETRANSLATEOPTION_FORCELD;
 else
   o := 0;
 end;
 MessageDlg(TapiLine1.TranslateAddress(Combobox2.Text, o), mtInformation, [mbOK], 0);
end;

end.
